---
title: Page load time · Cloudflare Web Analytics docs
description: "Page load time summary gives you an overview of how long your web
  page takes to load, broken down by area. To access Page load time:"
lastUpdated: 2024-12-10T09:57:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/web-analytics/data-metrics/page-load-time-summary/
  md: https://developers.cloudflare.com/web-analytics/data-metrics/page-load-time-summary/index.md
---

Page load time summary gives you an overview of how long your web page takes to load, broken down by area. To access Page load time:

1. Go to [Web Analytics](https://dash.cloudflare.com/?to=/:account/web-analytics) from your account home page, and choose a website.
2. Select **Page load time**.

## Components

Below is a list of all the components you can inspect:

### Page load

The total amount of time required to load the page. Note that page load time does not correspond to the sum of the other timings available in Web Analytics. This happens because the page load time also includes timings that are not displayed, such as pre-DNS lookup timings and unattributed gaps between timing metrics.

### DNS (`domainLookupEnd` - `domainLookupStart`)

How long a DNS query takes. This could appear as zero for reused connections or content stored in the local cache (memory or disk).

### TCP (`connectEnd` - `connectStart`)

How long it takes to establish a TCP connection with the server. If using HTTPS, this process includes TLS negotiation time.

### Request (`responseStart` - `requestStart`)

The time elapsed between making an HTTP request and receiving the first byte of the response.

### Response (`responseEnd` - `responseStart`)

The time elapsed between the first byte and the last byte of the received response. Think of this as a resource download time.

### Processing (`domComplete` - `domInteractive`)

How long it took to render the page. This includes loading any resources that block page rendering, including images, scripts, and style sheets. If this number is big, optimize your document architecture, resource size, or configure settings in the Cloudflare Speed app. This document process can be drilled down more with `domInteractive`, `domContentLoadedEventStart`, `domContentLoadedEventEnd`, and `domComplete`.

### Load Event (`loadEventEnd` - `loadEventStart`)

An event triggered by the browser when a document and its resources finish loading. The Load Event duration may be a useful metric if you have additional functions or any logic for the load event.

![Web Analytics load time summary page](https://developers.cloudflare.com/_astro/dash-web_analytics-page_load_time.CrUXAPNx_2us4uU.webp)

## Data collected for Paint Timings

To make Web Analytics work, Cloudflare collects several types of data points. These are the additional data points collected for Paint Timings:

### First Paint

The time between navigation and when the browser renders the first pixels to the screen.

### First Contentful Paint

Time when the browser renders the first bit of content from the DOM.
